-- CREATION DU CONTENU D'UNE BASE DE DONNEES
DROP TABLE IF EXISTS TYPE_SUPPORT;
CREATE TABLE type_support (
	nom		varchar(50)	PRIMARY KEY,
	icon		varchar(255)	NOT NULL
);

DROP TABLE IF EXISTS SUPPORT;
CREATE TABLE support (
	id_support		identity		PRIMARY KEY,
	nom				varchar(200)	NOT NULL,
	code_barre		varchar(30)	,
	nom_type_support	varchar(50)	NOT NULL,
	reference_interne	varchar(50)	,
	langues			varchar(255)	,
	information		text			,
	id_coffret		bigint		,
	id
	FOREIGN KEY 	(nom_type_support) REFERENCES type_support(nom)
);

DROP TABLE IF EXISTS MEDIUM;
CREATE TABLE medium (
	id_medium		identity		PRIMARY KEY,
	titre		varchar(255)	NOT NULL,
	titre_original	varchar(255)	,
	annee_sortie	YEAR			DEFAULT 1900,
	sortie		date			,
	genres		varchar(100)	,
	nationnalites	varchar(100)	,
	resume		text			,
	image		varchar(255)	,
	preference	tinyint		DEFAULT 10 COMMENT 'Note donnee par l''utilisateur',
	id_support	bigint		NOT NULL,
	information	text,
	FOREIGN KEY	(id_support) REFERENCES SUPPORT(ID_SUPPORT)
);

DROP TABLE IF EXISTS PERSONNE;
CREATE TABLE personne	(
	id_personne	identity		PRIMARY KEY,
	nom			varchar(100)	NOT NULL,
	email		varchar(255)	,
	information	text,
	UNIQUE	(email)			
);

DROP TABLE IF EXISTS emprunt;
CREATE TABLE emprunt (
	id_support	bigint	NOT NULL,
	id_personne	bigint	NOT NULL,
	debut		date		NOT NULL,
	fin			date		,
	dernier_rappel	date		,
	nb_rappels	tinyint	,
	PRIMARY KEY (id_support, id_personne, debut),
	FOREIGN KEY (id_support) REFERENCES SUPPORT(ID_SUPPORT)
);


DROP TABLE IF EXISTS emplacement;
CREATE TABLE emplacement (
	id_emplacement		identity		PRIMARY KEY,
	libelle		varchar(30)	NOT NULL,
	description	varchar(100)	,
);

DROP TABLE IF EXISTS repere;
CREATE TABLE repere (
	id_repere		identity		PRIMARY KEY,
	libelle		varchar(30)	NOT NULL,
	description	varchar(100)	,
	id_emplacement	bigint	,
	FOREIGN KEY (id_emplacement) REFERENCES emplacement(id_emplacement)
);

DROP TABLE IF EXISTS coffret;
CREATE TABLE coffret (
	id_coffret	identity		PRIMARY KEY,
	libelle		varchar(30)	NOT NULL,
	descrition	varchar(100)	,
	id_emplacement	bigint		,
	id_repere		bigint		,
	FOREIGN KEY (id_emplacement) REFERENCES EMPLACEMENT(ID_EMPLACEMENT),
	FOREIGN KEY (id_repere) REFERENCES REPERE(ID_REPERE)
);

DROP TABLE IF EXISTS video;
CREATE TABLE video (
	id_medium		bigint		PRIMARY KEY,
	distributor	varchar(50)	,
	duree		tinyint		COMMENT 'Dure en minutes',
	FOREIGN KEY (ID_MEDIUM) REFERENCES MEDIUM(ID_MEDIUM)
);

DROP TABLE IF EXISTS audio;
CREATE TABLE audio (
	id_medium		bigint		PRIMARY KEY,
	editor		varchar(50)	,
	duree		tinyint		COMMENT 'Dure en secondes',
	FOREIGN KEY (ID_MEDIUM) REFERENCES MEDIUM(ID_MEDIUM)
);

DROP TABLE IF EXISTS livre;
CREATE TABLE livre (
	id_medium		bigint		PRIMARY KEY,
	editor		varchar(50)	,
	pages		tinyint		COMMENT 'nombre de pages',
	reliure		varchar(50)	,
	FOREIGN KEY (ID_MEDIUM) REFERENCES MEDIUM(ID_MEDIUM)
);

-- Contient les diffrents roles que peut avoir une personne pour un medium peut-tre juste des constantes JAVA
--DROP TABLE ID EXISTS role;
--CREATE TABLE role (
--	code_role		varchar(4)	PRIMARY KEY,
--	libelle		varchar(30)	NOT NULL,
--	UNIQUE (libelle)
--);

-- Fusion des tables d'association entre medium et personne
DROP TABLE IF EXISTS role_personne;
CREATE TABLE role_personne (
	id_personne		bigint		NOT NULL,
	id_medium			bigint		NOT NULL,
	code_type_role		varchar(4)	NOT NULL,
	nom_role			varchar(100)	,
	supplements		text			COMMENT 'champ texte pouvant contenir des supplments d''informations comme des liens',
	PRIMARY KEY (ID_PERSONNE, ID_MEDIUM, code_role),
	FOREIGN KEY (id_personne) REFERENCES PERSONNE(ID_PERSONNE),
	FOREIGN KEY (id_medium) REFERENCES MEDIUM(ID_MEDIUM)
);













		

